package gov.va.med.mhv.usermgmt.persist.ldap;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.tigris.atlas.config.ConfigurationManager;

/**
 * This class models directory environment values that may possibly change between 
 * deployment environments.  Some schema-specific attributes are stored here as well.
 * These attributes will probably not change per-environment.
 *
 * @author Jon Crater Apr 7, 2006 9:05:29 AM
 */
public class LdapEnvironment {
	private Log logger = LogFactory.getLog(getClass());
	
	private static final LdapEnvironment INSTANCE = new LdapEnvironment();
	private static final String CFG_FILE = "/ldap.properties";

	private String host;
	private int port;
	private String baseDn;
	private String userBaseDn;
	private String userNameAttribute;
	private String userPasswordAttribute;
	private String adminPrincipal;
	private String adminPassword;
	private String objectClassAttribute;
	private String surNameAttribute;
	private String commonNameAttribute;
	private String[] objectClassValues;

	private LdapEnvironment() {
		try {
			init();
		}
		catch(IllegalStateException e) {
			throw e;
		}
		catch(Throwable t) {
			throw new ExceptionInInitializerError(t);
		}
	}

	public static LdapEnvironment getInstance() {
		return INSTANCE;
	}

	public int getPort() {
		return port;
	}

	public String getAdminPrincipal() {
		return adminPrincipal;
	}

	public String getAdminPassword() {
		return adminPassword;
	}

	public String getBaseDn() {
		return baseDn;
	}

	public String getHost() {
		return host;
	}
	
	public String getUserNameAttribute() {
		return userNameAttribute;
	}

	public void setUserNameAttribute(String userCn) {
		this.userNameAttribute = userCn;
	}

	public String getUserBaseDn() {
		return userBaseDn;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public void setBaseDn(String baseDn) {
		this.baseDn = baseDn;
	}

	public void setAdminPrincipal(String adminPrincipal) {
		this.adminPrincipal = adminPrincipal;
	}

	public void setAdminPassword(String adminPassword) {
		this.adminPassword = adminPassword;
	}

	public void setUserBaseDn(String userBaseDn) {
		this.userBaseDn = userBaseDn;
	}

	public void setHost(String host) {
		this.host = host;
	}
	
	public String getUserPasswordAttribute() {
		return userPasswordAttribute;
	}

	public void setUserPasswordAttribute(String userPasswordAttribute) {
		this.userPasswordAttribute = userPasswordAttribute;
	}
	
	public String getCommonNameAttribute() {
		return commonNameAttribute;
	}

	public void setCommonNameAttribute(String commonNameAttribute) {
		this.commonNameAttribute = commonNameAttribute;
	}

	public String getObjectClassAttribute() {
		return objectClassAttribute;
	}

	public void setObjectClassAttribute(String objectClassAttribute) {
		this.objectClassAttribute = objectClassAttribute;
	}

	public String getSurNameAttribute() {
		return surNameAttribute;
	}

	public void setSurNameAttribute(String surNameAttribute) {
		this.surNameAttribute = surNameAttribute;
	}
	
	public String[] getObjectClassValues() {
		return objectClassValues;
	}

	public void setObjectClassValues(String[] objectClassValues) {
		this.objectClassValues = objectClassValues;
	}

	public void setObjectClassValueArray(String delimited) {
		setObjectClassValues(delimited.split(","));
	}

	private void init() throws InvocationTargetException, IllegalAccessException, IOException {
		Properties props = ConfigurationManager.getConfiguration( CFG_FILE );

		PropertyDescriptor[] pdArray = BeanUtils.getPropertyDescriptors(getClass());
		for(int i = 0; i < pdArray.length; i++) {
			PropertyDescriptor pd = pdArray[i];
			Method writeMethod = pd.getWriteMethod();

			if(writeMethod == null)
				continue;

			String key = pd.getName();
			String strValue = props.getProperty(key);

			if(strValue == null)
				continue;

			Class valueType = pd.getPropertyType();
			if(valueType == String.class)
				writeMethod.invoke(this, new Object[]{strValue});
			else if(valueType == int.class) {
				writeMethod.invoke(this, new Object[]{new Integer(strValue)});
			}
		}
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		
		if(logger.isDebugEnabled()) {
			String sep = System.getProperty("line.separator");
			buf.append("=========================")
				.append(sep)
				.append("LdapEnvironment [" + hashCode() +"]")
				.append(sep);
			
			PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(getClass());
			for(int i = 0; i < pds.length; i++) {
				PropertyDescriptor pd = pds[i];
				Method readMethod = pd.getReadMethod();
				
				if(readMethod != null) {
					Class returnType = readMethod.getReturnType();
					Class[] params = readMethod.getParameterTypes();
					String name = readMethod.getName();
					
					if(params.length == 0 && returnType != Class.class && name.startsWith("get")) {
						Object value = null;
						
						try {
							value = readMethod.invoke(this, null);
						}
						catch(Throwable t) {
							value = "!!error!!";
						}
						
						buf.append(name).append('=').append(value).append(sep);
					}
				}
			}
			buf.append("=========================");
		}
		return buf.toString();
	}
}